/*
 * Decompiled with CFR 0.152.
 */
package com.night.star.shopjei.utils;

import dev.ftb.mods.ftblibrary.ui.Panel;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopTab;
import net.sixik.sdmshoprework.client.screen.basic.widget.AbstractShopEntryButton;
import net.sixik.sdmshoprework.client.screen.legacy.LegacyShopScreen;
import net.sixik.sdmshoprework.client.screen.legacy.buyer.LegacyBuyerScreen;
import net.sixik.sdmshoprework.client.screen.modern.ModernShopScreen;
import net.sixik.sdmshoprework.client.screen.modern.buyer.ModernBuyerScreen;
import net.sixik.sdmshoprework.client.screen.modern.widget.ModernShopEntryButton;
import net.sixik.sdmshoprework.common.config.Config;
import net.sixik.sdmshoprework.common.theme.ShopStyle;

public class SdmShopUIUtils {
    public static void openGui(AbstractShopTab shopTab) {
        ShopStyle shopStyle = (ShopStyle)Config.STYLE.get();
        switch (shopStyle) {
            case LEGACY: {
                LegacyShopScreen screen = new LegacyShopScreen(false);
                screen.openGui();
                screen.setSelectedTab(shopTab);
                screen.addEntriesButtons();
                break;
            }
            case MODERN: {
                ModernShopScreen screen = new ModernShopScreen(false);
                screen.openGui();
                screen.setSelectedTab(shopTab);
                screen.addEntriesButtons();
            }
        }
    }

    public static void openBuyGui(AbstractShopTab shopTab, AbstractShopEntry entry) {
        ShopStyle shopStyle = (ShopStyle)Config.STYLE.get();
        switch (shopStyle) {
            case LEGACY: {
                new LegacyBuyerScreen(entry).openGui();
                break;
            }
            case MODERN: {
                ModernShopScreen screen = new ModernShopScreen(false);
                screen.openGui();
                screen.setSelectedTab(shopTab);
                screen.addEntriesButtons();
                ModernShopEntryButton button = new ModernShopEntryButton((Panel)screen.entriesPanel, entry);
                new ModernBuyerScreen(screen, (AbstractShopEntryButton)button).openGui();
            }
        }
    }
}

